<?php
session_start();
require_once '../config/db.php';

// التحقق من صلاحية الدخول
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../src/login.php');
    exit;
}

// الرد أو الإشارة إلى "تم الرد"
if (isset($_GET['reply'])) {
    $id = intval($_GET['reply']);
    $stmt = $pdo->prepare("UPDATE messages SET status = 'تم الرد' WHERE id = ?");
    $stmt->execute([$id]);
}

// حذف رسالة
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $pdo->prepare("UPDATE messages SET status = 'محذوف' WHERE id = ?");
    $stmt->execute([$id]);
}

// جلب جميع الرسائل
$messages = $pdo->query("SELECT m.*, p.name as project_name, u.username as user_name FROM messages m LEFT JOIN projects p ON m.project_id = p.id LEFT JOIN users u ON m.user_id = u.id WHERE m.status != 'محذوف' ORDER BY m.id DESC")->fetchAll();
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>استفسارات العملاء</title>
    <link rel="stylesheet" href="../public/style.css">
    <style>
        body { background: #EEEEEE; font-family: 'Cairo', sans-serif; }
        .container { max-width: 1100px; margin: 40px auto; background: #fff; border-radius: 8px; box-shadow: 0 0 10px #31384122; padding: 32px; }
        h2 { color: #EA9218; margin-bottom: 24px; text-align: center; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 32px; }
        th, td { padding: 10px; border-bottom: 1px solid #EEEEEE; text-align: center; }
        th { background: #EA9218; color: #fff; }
        .btn { padding: 6px 16px; border-radius: 4px; border: none; cursor: pointer; }
        .btn-reply { background: #3A4750; color: #fff; }
        .btn-delete { background: #d00; color: #fff; }
        .status-new { color: #EA9218; font-weight: bold; }
        .status-replied { color: #3A4750; font-weight: bold; }
    </style>
</head>
<body>
    <div class="container">
        <h2>استفسارات العملاء</h2>
        <table>
            <tr>
                <th>الرقم</th>
                <th>اسم العميل</th>
                <th>البريد الإلكتروني</th>
                <th>الهاتف</th>
                <th>اسم المشروع</th>
                <th>الرسالة</th>
                <th>الحالة</th>
                <th>تاريخ الإرسال</th>
                <th>رد</th>
                <th>حذف</th>
            </tr>
            <?php foreach ($messages as $msg): ?>
            <tr>
                <td><?= $msg['id'] ?></td>
                <td><?= htmlspecialchars($msg['name']) ?></td>
                <td><?= htmlspecialchars($msg['email']) ?></td>
                <td><?= htmlspecialchars($msg['phone']) ?></td>
                <td><?= htmlspecialchars($msg['project_name']) ?></td>
                <td><?= nl2br(htmlspecialchars($msg['message'])) ?></td>
                <td class="<?= $msg['status']=='جديد'?'status-new':'status-replied' ?>"> <?= $msg['status'] ?> </td>
                <td><?= $msg['created_at'] ?></td>
                <td>
                    <?php if ($msg['status']=='جديد'): ?>
                        <a class="btn btn-reply" href="?reply=<?= $msg['id'] ?>">تم الرد</a>
                    <?php endif; ?>
                </td>
                <td>
                    <a class="btn btn-delete" href="?delete=<?= $msg['id'] ?>" onclick="return confirm('هل أنت متأكد من حذف الرسالة؟');">حذف</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
</body>
</html>
